<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:cif="cif" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.1">
<xsl:param select="cif:xslShowHelp" name="xslShowHelp"/>
<xsl:param select="cif:xslRootDirectory" name="xslRootDirectory"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title>Zaměření Výpis chybějících kódů</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Zaměření Výpis chybějících kódů</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>

                            <xsl:for-each select="SurveyMissingFeatures">
                                <table class="margin" cellpadding="2" width="80%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@name"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Jednotky:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@surveyLinearUnits"/>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>

                                <table class="margin" cellpadding="2" cellspacing="2" width="80%">
                                    <thead style="display:table-header-group">
                                        <tr>
                                            <th class="underline" lang="en" align="left">Chybějící kódy</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <xsl:for-each select="SurveyMissingFeatureList/SurveyMissingFeature">
                                            <tr>
                                                <td align="left">
                                                    <xsl:value-of select="@name"/>
                                                </td>
                                            </tr>
                                        </xsl:for-each>
                                    </tbody>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
           Pro tento výpis potřebujete nejméně jeden polní zápisník v Průzkumníku projektu (Zaměření), který obsahuje minimálně jedno nastavení měření.
	</p>

<p class="normal1">Pro nejlepší výsledek spusťte výpis z panelu Detaily. Vyberte všechna nastavení v Průzkumníku projektu, která jsou v panelu Detaily.  Zvýrazněte řádky, které chcete mít ve výpisu, a pravým tlačítkem zvolte Výpis na vybraných položkách.
</p>
<p class="normal1">Spuštění výpisu z obecného nástroje výpisu zaměření nebo kliknutí pravým tlačítkem na grafický prvek provede výpis pouze na jednom vybraném prvku. 
</p>
            <p class="normal1">Jakmile je otevřený Průzkumník výpisů, zvolte správný formulář, který umí číst vygenerovaná data pro výpis.</p>
            <p class="small" lang="en">
                <em>&#xa9; 2018 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
